<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">

    <!-- If IE use the latest rendering engine -->
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <!-- Set the page to the width of the device and set the zoon level -->
    <meta name="viewport" content="width = device-width, initial-scale = 1">
    <title>StellarMate Serial Port Assistant</title>
    <link rel="stylesheet" type="text/css" href="/static/css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="/static/css/all.min.css">
    <link rel="stylesheet" type="text/css" href="/static/css/jquery-ui.min.css">
    <link rel="stylesheet" type="text/css" href="/static/css/bootstrap-select.min.css">
    <link rel="stylesheet" type="text/css" href="/static/css/schoolhouse.css">
    <link rel="stylesheet" type="text/css" href="/static/css/index.css">

</head>
<body>

<div class="container">
<h4>
    <button onClick="$('#sm-wifi-info-button').popover('toggle');" id="sm-wifi-info-button" type="button"
            class="btn btn-info"><span class="fas fa-info fa-fw"></span></button>
    SM WiFi Manager
    <button onClick="window.history.back()" type="button" class="btn btn-info float-right"><span
            class="fas fa-home fa-fw"></span></button>
</h4>


<div class="row justify-content-start bottom-center">
    <div class="col-2">
        <label>IP:</label>
    </div>
    <div class="col-10">
        <strong><label id="sm-wifi-ip">10.250.250.1</label></strong>
    </div>
</div>
<div class="row bottom-center">
    <div class="col-2">
        <label>Mode:</label>
    </div>
    <div class="col-10">
        <div class="btn-group" role="group" aria-label="WiFi Mode">
            <button id="sm-mode-hotspot" type="button" class="btn" data-toggle="confirmation"
                    title="Switch to HotSpot Mode">HotSpot
            </button>
            <button id="sm-mode-infrastructure" type="button" class="btn" data-toggle="confirmation"
                    title="Switch to Infrastructure Mode">Infrastructure
            </button>
        </div>
    </div>
</div>
<div id="sm-ssid-block" class="row bottom-center">
    <div class="col-2">
        <label>SSID:</label>
    </div>
    <div class="col-10">
        <select id="sm-ssid-list" class="form-control">
        </select>
    </div>
</div>
<div id="sm-pass-block" class="row bottom-center">
    <div class="col-2">
        <label>Pass:</label>
    </div>
    <div class="col-10">
        <div class="input-group" id="show_hide_password">
            <input type="password" id="sm-ssid-password" placeholder="Enter password" class="form-control"/>
            <button type="button" class="btn">
                <span class="fa fa-eye-slash fa-fw" aria-hidden="true"></span>
            </button>
        </div>
    </div>
</div>

<div id="sm-connect-block" class="row bottom-center">
    <div class="col">
        <button id="sm-ssid-connect" class="btn btn-primary btn-block">
            Connect
        </button>
    </div>
</div>
<div id="sm-message-block" class="row bottom-center">
    <div class="col">
        <p id="sm-wifi-message" class="alert"></p>
    </div>
</div>


<script src="/static/js/jquery.min.js"></script>
<script src="/static/js/popper.min.js"></script>
<script src="/static/js/bootstrap.min.js"></script>
<script src="/static/js/bootstrap-confirmation.min.js"></script>
<script src="/static/js/wifi.js"></script>
</body>
</html>
