#!/bin/bash

# Detect OS
if [ -f /etc/os-release ]; then
    . /etc/os-release
    if [[ "$ID" == "arch" ]] || [[ "$ID_LIKE" == *"arch"* ]]; then
        OS_TYPE="arch"
        echo "Detected non-Debian/Ubuntu system. Skipping /etc/network/interfaces reset."
    else
        echo "Adding Debian/Ubuntu configuration for /etc/network/interfaces."
        cat <<EOM >$R/etc/network/interfaces
# interfaces(5) file used by ifup(8) and ifdown(8)
# Include files from /etc/network/interfaces.d:
source-directory /etc/network/interfaces.d

# The loopback network interface
auto lo
iface lo inet loopback
EOM
    fi
fi

# Reset NetworkManager connections (common for both)
rm -rf /etc/NetworkManager/system-connections/*
rsync -a /etc/stellarmate/NetworkManager/ /etc/NetworkManager/
# Must chmod 600 otherwise they will not load
chmod 600 /etc/NetworkManager/system-connections/*
chown -R root:root /etc/NetworkManager/system-connections

cp /etc/stellarmate/.hotspotiface /home/stellarmate
chown stellarmate:stellarmate /home/stellarmate/.hotspotiface
