<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8"/>
    <!-- If IE use the latest rendering engine -->
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <!-- Set the page to the width of the device and set the zoon level -->
    <meta name="viewport" content="width = device-width, initial-scale = 1"/>
    <title>StellarMate Serial Port Assistant</title>
    <link rel="stylesheet" type="text/css" href="/static/css/all.min.css"/>
    <link rel="stylesheet" type="text/css" href="/static/css/bootstrap.min.css"/>
    <link rel="stylesheet" type="text/css" href="/static/css/jquery-ui.min.css"/>
    <link rel="stylesheet" type="text/css" href="/static/css/bootstrap-select.min.css"/>
    <link rel="stylesheet" type="text/css" href="/static/css/schoolhouse.css"/>
    <link rel="stylesheet" type="text/css" href="/static/css/index.css"/>
</head>
<body>

<div class="container">
    <h4>
        <button onClick="$('#sm-assistant-info-button').popover('toggle');" id="sm-assistant-info-button" type="button"
                class="btn btn-info">
            <span class="fas fa-info fa-fw"></span></button>
        SM Serial Assistant
        <button onClick="window.history.back()" type="button" class="btn btn-info float-right">
            <span class="fas fa-home fa-fw"></span></button>
    </h4>

    <!-- <form> !-->

    <div class="row">
        <div class="col-sm-12">
            <h4><span class="fas fa-random fa-fw"></span> Existing Mappings</h4>
            <p id="mappings-message">No existing mappings exist. Please add new mappings below.</p>
            <div id="mappings-table" class="table-responsive">
                <table class="table .table-striped table-hover">
                    <thead>
                    <tr>
                        <th>Port</th>
                        <th>VID</th>
                        <th>PID</th>
                        <th>Serial</th>
                        <th>Action</th>
                    </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <h4><span class="fas fa-plus fa-fw"></span> New Mappings</h4>
            <div id="idle-stage">
                <p>Disconnect <strong>all</strong> devices from Stellarmate. Click <strong>Next</strong> when ready.</p>
                <p>
                    <button onClick="goNextStage()" id="sm-assistant-disconnected" type="button" class="btn btn-info">
                        <span class="fas fa-check fa-fw"></span> Next
                    </button>
                </p>
            </div>

            <div
            = id="select-stage">
            <p>What device do you want to map?</p>
            <p>
                <label class="radio-inline"><input type="radio" name="devtype" value="mount" checked/>Mount</label>
                <label class="radio-inline"><input type="radio" name="devtype" value="focuser"/>Focuser</label>
                <label class="radio-inline"><input type="radio" name="devtype" value="filter_wheel"/>Filter
                    Wheel</label>
                <label class="radio-inline"><input type="radio" name="devtype" value="gps"/>GPS</label>
                <div class="input-group">
            <span class="input-group-addon">
                <input type="radio" name="devtype" value="other">
            </span>
                    <input name="othertype" type="text" class="form-control" placeholder="Other">
                </div>
            </p>
            <p>
                <button onClick="$('#sm-assistant-hardware-button').popover('toggle');"
                        id="sm-assistant-hardware-button" type="button" class="btn btn-info">
                    <span class="fas fa-server fa-fw" aria-hidden="true"></span></button>
                <label class="checkbox-inline"><input type="checkbox" name="hardware_usb" value="hardware_usb">Hardware
                    slot mappings</label>
            </p>
            <p>
                <button onClick="$('#sm-bluetooth-hardware-button').popover('toggle');"
                        id="sm-bluetooth-hardware-button" type="button" class="btn btn-info">
                    <span class="fab fa-bluetooth-b fa-fw" aria-hidden="true"></span></button>
                <label class="checkbox-inline"><input type="checkbox" name="hardware_bluetooth" value="hardware_bluetooth">Bluetooth device</label>
            </p>
            <p>
                <button onClick="goNextStage()" id="sm-assistant-next" type="button" class="btn btn-info">
                    <span class="fas fa-check fa-fw"></span> Next
                </button>
                <button onClick="restartStage()" id="sm-assistant-restart" type="button" class="btn btn-info">
                    <span class="fas fa-redo fa-fw"></span> Restart
                </button>
            </p>
        </div>

        <div id="bt-paired-stage">
            <div class="row">
            <div class="col-sm-12">
                <h4><span class="fas fa-random fa-fw"></span> Paired Bluetooth Devices</h4>
                <p id="bt-message">
                Please select a bluetooth device from the list, or click on Scan if you want to pair a new device.
                <button onClick="bluetoothUnbind()" id="sm-rescan-bt" type="button" class="btn btn-info">
                    <span class="fas fa-trash-alt fa-fw"></span> Unbind Previous Device
                </button>
                </p>
                <div id="bt-pdevices-table" class="table-responsive">
                    <table class="table .table-striped table-hover">
                        <thead>
                        <tr>
                            <th>Name</th>
                            <th>Mac Address</th>
                            <th>Bind</th>
                           <!-- <th>Serial</th>
                            <th>Action</th> -->
                        </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
            </div>
            <p>
                <button onClick="goNextStage()" id="sm-assistant-next" type="button" class="btn btn-info">
                    <span class="fas fa-plus-circle fa-fw"></span> Add New Device
                </button>
            </p>
        </div>

        <div id="connect-stage">
            <p>Please connect the device you want to map and make sure it is powered.</p>
            <p>Scanning for new devices...<i class="fas fa-spinner fa-spin"></i></p>
        </div>

        <div id="bt-connect-stage">
            <p>Please make sure your bluetooth dongle is connected to your instrument and make sure it is powered.</p>
            <p>Scanning for new devices...<i class="fas fa-spinner fa-spin"></i></p>
        </div>

        <div id="bt-detect-stage">
            <div class="row">
            <div class="col-sm-12">
                <h4><span class="fas fa-random fa-fw"></span> Bluetooth Devices</h4>
                <p id="bt-message">
                Please select a bluetooth device from the list.
                <button onClick="bluetoothDevices()" id="sm-rescan-bt" type="button" class="btn btn-info">
                    <span class="fas fa-redo-alt fa-fw"></span> RESCAN
                </button>
                </p>
                <div id="bt-devices-table" class="table-responsive">
                    <table class="table .table-striped table-hover">
                        <thead>
                        <tr>
                            <th>Name</th>
                            <th>Mac Address</th>
                            <th>Pin Code</th>
                            <th>Connect</th>
                           <!-- <th>Serial</th>
                            <th>Action</th> -->
                        </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
            </div>
        </div>



        <div id="detect-stage">
            <p>Successfully detected a serial device with Vendor ID (0x0132), Product ID (0x3456), and Serial
                (1234567).</p>
            <p>
                <button onClick="" id="sm-assistant-add" type="button" class="btn btn-info">
                    <span class="fas fa-plus fa-fw"></span> Add
                </button>
                <button onClick="" id="sm-assistant-restart2" type="button" class="btn btn-info">
                    <span class="fas fa-redo fa-fw"></span> Restart
                </button>
            </p>
        </div>

        <div id="fail-stage">
            <p>Failed to detect any device, please restart the process and try again.</p>
            <p>
                <button onClick="" id="sm-assistant-connected" type="button" class="btn btn-info">
                    <span class="fas fa-redo fa-fw"></span> Restart
                </button>
            </p>
        </div>
    </div>
</div>

<script src="/static/js/jquery.min.js"></script>
<script src="/static/js/popper.min.js"></script>
<script src="/static/js/bootstrap.min.js"></script>
<script src="/static/js/bootstrap-select.min.js"></script>
<script src="/static/js/bootbox.min.js"></script>
<script src="/static/js/jquery-ui.min.js"></script>
<script src="/static/js/assistant.js"></script>
</body>
</html>
