#!/bin/sh

if command -v dpkg-query &> /dev/null; then
    # Debian/Ubuntu
    webmanager=`dpkg-query --showformat='${Version}' --show stellarmatewebmanager | cut -f1 -d'~'`
    udevmanager=`dpkg-query --showformat='${Version}' --show stellarmateudevmanager | cut -f1 -d'~'`
    networkmanager=`dpkg-query --showformat='${Version}' --show stellarmatenetworkmanager | cut -f1 -d'~'`
elif command -v pacman &> /dev/null; then
    # Arch Linux
    get_pacman_version() {
        pacman -Q "$1" 2>/dev/null | awk '{print $2}' | cut -f1 -d'-'
    }
    webmanager=$(get_pacman_version stellarmatewebmanager)
    udevmanager=$(get_pacman_version stellarmateudevmanager)
    networkmanager=$(get_pacman_version stellarmatenetworkmanager)
else
    webmanager="N/A"
    udevmanager="N/A"
    networkmanager="N/A"
fi

echo '[{"name":"webmanager","version":"'$webmanager'"},{"name":"udevmanager","version":"'$udevmanager'"},{"name":"networkmanager","version":"'$networkmanager'"}]'
