#!/bin/bash

# Source common reset functions
source /etc/stellarmate/reset-factory-common.sh

# Perform common reset operations with stellarmate hostname
perform_common_reset "stellarmate"

# SM-170 specific operations

cp /etc/stellarmate/kstars/config/* /home/stellarmate/.var/app/org.kde.kstars/config/

rm -rf /home/stellarmate/.var/app/org.kde.kstars/data/kstars
mkdir -p /home/stellarmate/.var/app/org.kde.kstars/data/kstars
cp /etc/stellarmate/kstars/catalogs/* /home/stellarmate/.var/app/org.kde.kstars/data/kstars/

# Reset Plasma settings
cp -rf /etc/stellarmate/plasma/* /home/stellarmate/.config

# Reset boot to default settings
echo "Resetting boot to default..."
cp /etc/stellarmate/boot/* /boot/


# Clean up Raspberry Pi specific files
rm -f /boot/.firmware_revision || true
rm -rf /boot.bak || true

# Enable filesystem resize service
echo "Enabling resize file system service..."
systemctl enable resize-fs.service

echo "Reset complete. StellarMate must be restarted now."
