#!/bin/bash

# Source common reset functions
source /etc/stellarmate/reset-factory-common.sh

# Additional cleanup specific to SM-130
rm -rf /home/stellarmate/pmic || true
rm -rf /etc/stellarmate/8gb || true

# Perform common reset operations with stellarmate hostname
perform_common_reset "stellarmate"

cp /etc/stellarmate/kstars/config/* /home/stellarmate/.config
cp /etc/stellarmate/kstars/catalogs/* /home/stellarmate/.local/share/kstars

# SM-130 specific operations
# Set plymouth theme
plymouth-set-default-theme stellarmate-logo

# Reset boot to default settings
echo "Resetting boot to default..."

# Detect OS version
if grep -q "bullseye" /etc/os-release; then
    echo "Detected Bullseye, using appropriate config..."
    cp /etc/stellarmate/boot/bullseye/config.txt /boot/
elif grep -q "bookworm" /etc/os-release; then
    echo "Detected Bookworm, using appropriate config..."
    cp /etc/stellarmate/boot/bookworm/config.txt /boot/
else
    echo "Warning: Unable to detect OS version, defaulting to Bookworm config..."
    cp /etc/stellarmate/boot/bookworm/config.txt /boot/
fi

# Copy other boot files (excluding bullseye and bookworm directories)
rsync -avz --exclude 'bullseye' --exclude 'bookworm' /etc/stellarmate/boot/ /boot

# Clean up Raspberry Pi specific files
rm -f /boot/.firmware_revision || true
rm -rf /boot.bak || true


# Clean apt cache and remove RPi specific packages
apt-get -y purge rpi.gpio-common modemmanager

# Hold specific packages
apt-mark hold firmware-atheros firmware-misc-nonfree firmware-libertas raspberrypi-kernel rpi-eeprom raspberrypi-bootloader firmware-brcm80211

echo "Setting StellarMate logo for Main Menu..."
cp /etc/stellarmate/icon.png /usr/share/icons/PiXflat/48x48/places/start-here.png
cp /etc/stellarmate/icon.png /usr/share/icons/PiXflat/32x32/places/start-here.png
gtk-update-icon-cache -f /usr/share/icons/PiXflat

# Enable filesystem resize service
echo "Enabling resize file system service..."
systemctl enable resize-fs.service

echo "Reset complete. StellarMate must be restarted now."
