#!/bin/bash

if [ $# -eq 0 ]; then
echo "No file name passed."
exit 0
fi

filename=$1
directory=${filename%_*}
service=${directory//\/tmp\/}
service=${service//-}

unzip $filename -d /tmp

if [ "$directory" = "/tmp/ekoslive" ]; then
    rm -rf /opt/ekoslive
    mv $directory /opt
    chown -R stellarmate:stellarmate /opt/ekoslive
else
    # first delete older versions
    find /usr/local/lib -type d -name "$service*" -exec rm -r {} \;
    cd $directory
    python3 setup.py install
fi

rm -rf $directory*

systemctl restart $service

exit 0

