#!/bin/bash

# Source common reset functions
source /etc/stellarmate/reset-factory-common.sh

# Perform common reset operations with stellarmate hostname
perform_common_reset "stellarmate"

# SM-160 specific operations

cp /etc/stellarmate/kstars/config/* /home/stellarmate/.var/app/org.kde.kstars/config/

rm -rf /home/stellarmate/.var/app/org.kde.kstars/data/kstars
mkdir -p /home/stellarmate/.var/app/org.kde.kstars/data/kstars
cp /etc/stellarmate/kstars/catalogs/* /home/stellarmate/.var/app/org.kde.kstars/data/kstars/

# Reset Plasma settings
cp -rf /etc/stellarmate/plasma/* /home/stellarmate/.config

# Enable RustDesk password change service
echo "Enabling RustDesk password change service..."
sudo -u stellarmate systemctl --user enable rustdesk-pass-change.service

echo "Reset complete. StellarMate must be restarted now."
