"""
StellarMate OS Integrity Check - Core Module
Version: 1.0.0

This package provides core functionality for file integrity checking
with SHA256 verification, section-based mutability rules, and auto-repair.
"""

__version__ = "1.0.0"
__author__ = "StellarMate Team"

from .checksum import ChecksumCalculator
from .logger import IntegrityLogger
from .section_parser import SectionParser
from .rule_engine import RuleEngine
from .file_checker import FileChecker
from .recovery import RecoveryManager

__all__ = [
    'ChecksumCalculator',
    'IntegrityLogger',
    'SectionParser',
    'RuleEngine',
    'FileChecker',
    'RecoveryManager'
]
